/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FolderLock;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.MandIter;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.PixelIterator;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.srv.AreaHandler;
import com.mandelsoft.mand.srv.ImageData;
import com.mandelsoft.mand.srv.Request;
import com.mandelsoft.mand.srv.Server;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.util.ChangeEvent;
import com.mandelsoft.util.ChangeListener;
import com.mandelsoft.util.StateChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Set;

public class ImageHandler
implements Request {
    private AbstractFile mandelfile;
    private MandelFileName name;
    private Environment env;
    private boolean accepted;
    private Exception err;
    private FolderLock lock;
    private Server server;
    private long starttime;
    private File file;
    private MandelData md;
    private MandelInfo mi;
    private PixelIterator pi;
    private int limit;
    private int[][] raster;
    private StateChangeSupport listeners = new StateChangeSupport();

    public ImageHandler(Environment env, AbstractFile f) {
        this.mandelfile = f;
        this.env = env;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Server server) {
        this.server = server;
        this.accepted = false;
        this.name = MandelFileName.create(this.mandelfile);
        MandelScanner imagescan = this.env.getImageDataScanner();
        if (this.name == null) {
            return;
        }
        try {
            MandelData req;
            MandelData old = null;
            this.lock = new FolderLock(this.mandelfile.getFile());
            if (!this.lock.lock()) {
                return;
            }
            try {
                if (!this.mandelfile.tryLock()) {
                    return;
                }
            }
            finally {
                this.lock.releaseLock();
            }
            System.out.println("got lock for " + this.mandelfile);
            try {
                req = new MandelData(this.mandelfile, false);
            }
            catch (IOException io) {
                this.mandelfile.releaseLock();
                if (this.mandelfile.getFile().length() == 0L) {
                    this.mandelfile.getFile().delete();
                }
                return;
            }
            MandelInfo reqd = req.getInfo();
            Set<MandelHandle> set = imagescan.getMandelHandles(this.name.getQualifiedName());
            if (!set.isEmpty()) {
                for (MandelHandle h : set) {
                    if (!h.getHeader().hasRaster()) continue;
                    try {
                        MandelData md = h.getData();
                        MandelInfo mi = md.getInfo();
                        System.out.println("requested " + reqd.getLimitIt() + " found " + h.getFile() + ": " + mi.getLimitIt());
                        if (!reqd.getDX().equals(mi.getDX()) || !reqd.getDY().equals(mi.getDY()) || !reqd.getXM().equals(mi.getXM()) || !reqd.getYM().equals(mi.getYM()) || reqd.getRX() != mi.getRX() || reqd.getRY() != mi.getRY()) continue;
                        old = md;
                        break;
                    }
                    catch (IOException io) {
                    }
                }
                if (old == null || old.getInfo().getLimitIt() >= reqd.getLimitIt()) {
                    System.out.println(this.mandelfile + " skipped");
                    this.lock.lock();
                    try {
                        this.mandelfile.releaseLock();
                        ImageHandler.cleanupInfo(this.env, this.mandelfile);
                    }
                    finally {
                        this.lock.releaseLock();
                    }
                    return;
                }
            }
            this.setup(req, old);
            this.start();
        }
        catch (IOException io) {
            System.err.println("*** " + this.mandelfile + ": " + io);
        }
    }

    private void start() {
        boolean recalc = this.md.getRaster() != null;
        System.out.println((recalc ? "re" : "") + "calculating " + (this.file == null ? "" : this.file) + "...");
        if (this.md.getRaster() != null && this.md.getInfo().getMaxIt() > this.limit) {
            System.out.println("nothing to be done");
            return;
        }
        this.starttime = System.currentTimeMillis();
        ImageData data = new ImageData(this.name, recalc, this.pi.getPrecision(), this.pi.getMagnification(), this.starttime);
        this.server.addImage(data);
        if (!recalc) {
            this.mi.setTime(0);
        }
        this.raster = this.md.createRaster().getRaster();
        AreaHandler area = new AreaHandler(this.server, recalc, true, this.md, 0, 0, this.mi.getRX(), this.mi.getRY());
        area.setPixelIterator(this.pi);
        area.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AreaHandler area = (AreaHandler)e.getSource();
                ImageHandler.this.mi.setTime(ImageHandler.this.mi.getTime() + (int)(area.getMTime() / 1000L));
                ImageHandler.this.done();
            }
        });
        this.accepted = true;
        area.send(this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        long end = System.currentTimeMillis();
        int efftime = (int)((end - this.starttime) / 1000L);
        this.mi.setEffectiveTime(efftime);
        this.mi.setRasterCreationTime(end);
        this.server.removeImage(this.name);
        try {
            this.write(false);
            this.lock.lock();
            try {
                this.mandelfile.releaseLock();
                System.out.println("release lock for " + this.mandelfile);
                if (!this.mandelfile.getName().equals(this.getFile().getName())) {
                    ImageHandler.cleanupInfo(this.env, this.mandelfile);
                }
            }
            finally {
                this.lock.releaseLock();
            }
        }
        catch (IOException io) {
            this.err = io;
            System.err.println("*** " + this.mandelfile + ": " + io);
        }
        this.listeners.fireChangeEvent(this);
    }

    public AbstractFile getMandelFile() {
        return this.mandelfile;
    }

    public Exception getError() {
        return this.err;
    }

    public void setPixelIterator(PixelIterator pi) {
        this.pi = pi;
    }

    private void setup(MandelData md) {
        this.md = md;
        this.mi = md.getInfo();
        this.limit = this.mi.getLimitIt();
        this.file = this.env.mapToRasterFile(md.getFile());
    }

    private void setup(MandelData md, MandelData old) throws IOException {
        this.setup(md);
        if (old != null && old.getFile().isFile()) {
            md.setRaster(old.getRaster());
            md.setMapper(ColormapModel.ResizeMode.RESIZE_LOCK_COLORS, old.getMapper());
            this.mi.setSite(old.getInfo().getSite());
            this.mi.setCreator(old.getInfo().getCreator());
            this.mi.setLocation(old.getInfo().getLocation());
            this.mi.setName(old.getInfo().getName());
            this.file = old.getFile().getFile();
        } else {
            this.file = this.env.mapToRasterFile(md.getFile());
        }
        this.pi = MandIter.createPixelIterator(this.mi.getXMin(), this.mi.getYMax(), this.mi.getDX(), this.mi.getDY(), this.mi.getRX(), this.mi.getRY(), this.mi.getLimitIt());
        System.out.println("precision set to " + this.pi.getPrecision() + "(" + this.pi.getMagnification() + ")");
        this.mi.setMinIt(this.limit);
    }

    public File getFile() {
        return this.file;
    }

    private void write(boolean verbose) throws IOException {
        if (this.file == null) {
            throw new IOException("no file specified");
        }
        this.md.write(this.file, verbose);
        System.out.println(new Date() + ": " + this.file + " done: " + MandUtils.time(this.md.getInfo().getTime()));
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    private static void cleanupInfo(Environment env, AbstractFile f) {
        if (!env.backupInfoFile(f) && env.isCleanupInfo() && f.isFile()) {
            System.out.println("deleting " + f);
            f.getFile().delete();
        }
    }
}

