/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.thumb.AsyncThumbnailFactory;
import com.mandelsoft.mand.tool.thumb.ImageChangeListener;
import com.mandelsoft.mand.tool.thumb.ImageSource;
import com.mandelsoft.mand.tool.thumb.ThumbnailFactory;
import com.mandelsoft.swing.ThumbnailListModel;
import com.mandelsoft.swing.ThumbnailListener;
import com.mandelsoft.swing.ThumbnailListenerSupport;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMandelListModel<E>
extends AbstractListModel
implements ThumbnailListModel<E> {
    protected AsyncThumbnailFactory factory;
    private ThumbnailListenerSupport<E> listeners = new ThumbnailListenerSupport();
    private Listener listener;
    private boolean modifiable;

    protected AbstractMandelListModel() {
        this.factory = new AsyncThumbnailFactory(new ThumbnailFactory.Client(){

            public boolean usesThumbnail(QualifiedMandelName name) {
                return AbstractMandelListModel.this.usesThumbnail(name);
            }

            public MandelScanner getMandelScanner() {
                return AbstractMandelListModel.this.getMandelScanner();
            }
        });
        this.listener = new Listener();
        this.factory.addImageChangeListener(this.listener);
    }

    @Override
    public void removeThumbnailListener(ThumbnailListener<E> l) {
        this.listeners.removeThumbnailListener(l);
    }

    @Override
    public void addThumbnailListener(ThumbnailListener<E> l) {
        this.listeners.addThumbnailListener(l);
    }

    public void refresh() {
        this.refresh(false);
    }

    public abstract void refresh(boolean var1);

    public void setModifiable(boolean m) {
        this.modifiable = m;
    }

    public void setFactory(MandelImage.Factory factory) {
        this.factory.setFactory(factory);
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    protected void checkModifiable() {
        if (!this.isModifiable()) {
            throw new UnsupportedOperationException();
        }
    }

    protected void fireRefresh(int old, int n) {
        if (old > n) {
            this.fireIntervalRemoved(this, n, old - 1);
            if (n > 0) {
                this.fireContentsChanged(this, 0, n - 1);
            }
        } else {
            if (old > 0) {
                this.fireContentsChanged(this, 0, old - 1);
            }
            this.fireIntervalAdded(this, old, n - 1);
        }
    }

    protected E lookup(ImageSource<QualifiedMandelName> src) {
        return this.lookupElement(src.getImageSpec());
    }

    protected abstract boolean usesThumbnail(QualifiedMandelName var1);

    protected abstract MandelScanner getMandelScanner();

    protected abstract QualifiedMandelName getQualifiedName(E var1);

    protected abstract E lookupElement(QualifiedMandelName var1);

    @Override
    public BufferedImage getThumbnail(int index, Dimension max) {
        QualifiedMandelName n = this.getQualifiedName(this.getElementAt(index));
        return this.factory.getThumbnail(n, max);
    }

    @Override
    public BufferedImage getThumbnail(E element, Dimension max) {
        return this.factory.getThumbnail(this.getQualifiedName(element), max);
    }

    protected void cleanupThumbnails() {
        this.factory.cleanupThumbnails();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements ImageChangeListener<QualifiedMandelName> {
        private Listener() {
        }

        @Override
        public void imageChanged(ImageSource<QualifiedMandelName> c) {
            AbstractMandelListModel.this.listeners.fireThumbnailChanged(AbstractMandelListModel.this, AbstractMandelListModel.this.lookup(c), c.getImage());
        }
    }
}

