/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.util.ColormapList;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ColormapTransferable
implements Transferable {
    public static final String colormapType = "application/x-java-jvm-local-objectref;class=" + ColormapTransferable.class.getName();
    public static final DataFlavor colormapFlavor;
    private ColormapInfo[] colormaps;
    private ColormapList source;

    public ColormapTransferable(ColormapInfo[] colormaps) {
        this.colormaps = colormaps;
    }

    public ColormapTransferable(ColormapList src, ColormapInfo[] colormaps) {
        this(colormaps);
        this.source = src;
    }

    public ColormapInfo[] getColormaps() {
        return this.colormaps;
    }

    public ColormapList getSource() {
        return this.source;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(colormapFlavor)) {
            return this;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            StringBuffer sb = new StringBuffer();
            String sep = "";
            for (ColormapInfo n : this.colormaps) {
                sb.append(sep);
                sb.append(n.toString());
                sep = "\n";
            }
            return sb.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{colormapFlavor, DataFlavor.stringFlavor};
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(colormapFlavor) || flavor.equals(DataFlavor.stringFlavor);
    }

    static {
        try {
            colormapFlavor = new DataFlavor(colormapType);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("illegal drag and drop class: " + ex);
            throw new IllegalArgumentException("illegal drag and drop class", ex);
        }
    }

    public static class ColormapInfo {
        ColormapName name;
        Colormap colormap;
        ColormapHandle handle;

        public ColormapInfo(ColormapName name, Colormap colormap, ColormapHandle handle) {
            this.name = name;
            this.colormap = colormap;
            this.handle = handle;
        }

        public Colormap getColormap() {
            return this.colormap;
        }

        public ColormapHandle getColormapHandle() {
            return this.handle;
        }

        public ColormapName getName() {
            return this.name;
        }

        public String toString() {
            if (this.handle == null || this.handle.getFile() == null) {
                return this.getName().getName();
            }
            return this.handle.getFile().toString();
        }
    }
}

