/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.AbstractMandelListListModel;
import com.mandelsoft.mand.util.MandelList;
import java.io.IOException;
import javax.swing.JOptionPane;

public class DefaultMandelListListModel
extends AbstractMandelListListModel {
    protected MandelList list;
    protected MandelScanner scanner;
    protected boolean duplicates;

    protected DefaultMandelListListModel() {
    }

    public DefaultMandelListListModel(MandelList list, MandelScanner scanner) {
        this.scanner = scanner;
        this.list = list;
    }

    public void setDuplicates(boolean m) {
        this.duplicates = m;
    }

    public boolean allowDuplicates() {
        return this.duplicates;
    }

    public MandelScanner getMandelScanner() {
        return this.scanner;
    }

    public void add(QualifiedMandelName name) {
        this.checkModifiable();
        if (this.duplicates || !this.list.contains(name)) {
            int max = this.list.size();
            this.list.add(name);
            if (this.list.size() != max) {
                try {
                    this.list.save();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
                }
                int index = max;
                this.fireIntervalAdded(this, index, index);
            }
        }
    }

    public void add(int index, QualifiedMandelName name) {
        if (index >= this.list.size()) {
            this.add(name);
        }
        this.checkModifiable();
        if (this.duplicates || !this.list.contains(name)) {
            int max = this.list.size();
            this.list.add(index, name);
            if (this.list.size() != max) {
                try {
                    this.list.save();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
                }
                this.fireIntervalAdded(this, index, index);
            }
        }
    }

    public void addAll(QualifiedMandelName[] names) {
        int cnt = 0;
        this.checkModifiable();
        int max = this.list.size();
        for (QualifiedMandelName name : names) {
            if (!this.duplicates && this.list.contains(name)) continue;
            this.list.add(name);
            if (this.list.size() == max + cnt) continue;
            ++cnt;
        }
        if (cnt != 0) {
            try {
                this.list.save();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
            }
            int index = this.list.size();
            this.fireIntervalAdded(this, index - cnt, index - 1);
        }
    }

    public void addAll(int index, QualifiedMandelName[] names) {
        int cnt = 0;
        if (index >= this.list.size()) {
            this.addAll(names);
        }
        this.checkModifiable();
        int max = this.list.size();
        for (QualifiedMandelName name : names) {
            if (!this.duplicates && this.list.contains(name)) continue;
            this.list.add(index + cnt, name);
            if (this.list.size() == max + cnt) continue;
            ++cnt;
        }
        if (cnt != 0) {
            try {
                this.list.save();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
            }
            this.fireIntervalAdded(this, index, index + cnt - 1);
        }
    }

    public void remove(QualifiedMandelName name) {
        this.checkModifiable();
        int index = this.list.indexOf(name);
        if (index >= 0) {
            this.list.remove(index);
            if (!this.list.contains(name)) {
                this.factory.remove(name);
            }
            try {
                this.list.save();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
            }
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public MandelList getList() {
        return this.list;
    }

    public void setList(MandelList list) {
        MandelList old = this.list;
        this.list = list;
        if (old != null && list != null) {
            this.fireRefresh(old.size(), list.size());
        }
    }

    public void refresh(boolean soft) {
        int old = this.list.size();
        this.list.refresh(soft);
        this.fireRefresh(old, this.list.size());
    }

    public void refresh(Environment env) {
        int old = this.list.size();
        env.refresh(this.list);
        this.fireRefresh(old, this.list.size());
    }

    public void clear() {
        this.checkModifiable();
        int old = this.list.size();
        this.getList().clear();
        this.fireRefresh(old, this.list.size());
    }
}

