/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.DefaultMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.DefaultMandelListTableModel;
import com.mandelsoft.mand.tool.MandelListFolderListModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelListener;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelSupport;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.mand.util.UniqueArrayMandelList;
import com.mandelsoft.swing.DnDTreeModel;
import com.mandelsoft.swing.TreeModelListenerSupportBase;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Stack;
import javax.swing.DropMode;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelListFolderBrowserModel
extends TreeModelListenerSupportBase
implements MandelListFolderTreeModel {
    private static boolean debug = false;
    public static final String PROP_MODIFIABLE = "modifiable";
    public static final String PROP_MODEL = "model";
    public static final String PROP_ACTIVE_NAME = "activeName";
    public static final String PROP_ACTIVE_PATH = "activePath";
    public static final String PROP_ACTIVE_FOLDER = "activeFolder";
    private MandelListFolderTreeModel fmodel;
    private TreePath activepath;
    private MandelListFolder activefolder;
    private String activename;
    private MandelListTableModel lmodel;
    private MandelListTableModel lempty = new DefaultMandelListTableModel(new UniqueArrayMandelList(), null);
    private MandelListFolderTreeModel fempty = new DefaultMandelListFolderTreeModel("empty", this.lempty);
    private ForwardingListener listener = new ForwardingListener();
    private boolean modifiable;

    public MandelListFolderBrowserModel(MandelListFolderTreeModel fmodel) {
        this.setFolderTreeModel(fmodel);
    }

    @Override
    public void clear() {
        this.setFolderTreeModel(null);
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public void setModifiable(boolean modifiable) {
        System.out.println("browser model modifiable: " + modifiable);
        if (this.modifiable != modifiable) {
            this.modifiable = modifiable;
            this.firePropertyChange(PROP_MODIFIABLE, !modifiable, modifiable);
        }
    }

    public void setFolderTreeModel(MandelListFolderTreeModel model) {
        if (model == null) {
            model = this.fempty;
        }
        if (model != this.fmodel) {
            MandelListFolderTreeModel old = this.fmodel;
            if (old != null) {
                old.removeTreeModelListener(this.listener);
            }
            this.fmodel = model;
            if (this.fmodel != null) {
                this.fmodel.addTreeModelListener(this.listener);
            }
            this.firePropertyChange(PROP_MODEL, old, this.fmodel);
            this.setModifiable(this.fmodel.isModifiable());
            this.setActivePath(new TreePath(this.fmodel.getRoot()));
            this.fireTreeStructureChanged(new TreePath(this.fmodel.getRoot()));
        }
    }

    public MandelListFolderTreeModel getFolderTreeModel() {
        if (this.fmodel == this.fempty) {
            return null;
        }
        return this.fmodel;
    }

    public void setActiveFolder(MandelListFolder f) {
        if (f.getMandelListFolderTree() != this.getFolderTreeModel().getFolderTree()) {
            throw new IllegalArgumentException("non matching folder tree");
        }
        this.setActivePath(MandelListFolderTreeModelSupport.getPathToRoot(f));
    }

    public void setActivePath(TreePath path) {
        this.setActivePath(path, false);
    }

    private void setActivePath(TreePath path, boolean obsolete) {
        if (path == null) {
            path = new TreePath(this.fmodel.getRoot());
        }
        TreePath oldpath = this.activepath;
        MandelListFolder folder = (MandelListFolder)path.getLastPathComponent();
        if (folder != this.activefolder) {
            if (folder != null && !this.fmodel.isLocalFolder(folder)) {
                throw new IllegalArgumentException("setting non local folder");
            }
            MandelListFolder oldfolder = this.activefolder;
            this.activefolder = folder;
            this.activepath = path;
            MandelListTableModel mandelListTableModel = this.lmodel = folder == null ? null : this.fmodel.getMandelListModel(this.activefolder);
            if (this.lmodel == null) {
                System.out.println("set empty list");
                this.lmodel = this.lempty;
            }
            this.firePropertyChange(PROP_ACTIVE_FOLDER, oldfolder, this.activefolder);
            if (!obsolete && oldfolder != null) {
                this.fireTreeNodesChanged(oldpath, null, null);
            }
            if (this.activefolder != null) {
                this.fireTreeNodesChanged(this.activepath, null, null);
            }
        }
        this.updateActiveName();
        if (!this.activepath.equals(oldpath)) {
            this.firePropertyChange(PROP_ACTIVE_PATH, oldpath, this.activepath);
        }
    }

    public TreePath getActivePath() {
        return this.activepath;
    }

    public MandelListFolder getActiveFolder() {
        return this.activefolder;
    }

    public MandelListTableModel getActiveListModel() {
        return this.lmodel;
    }

    public String getActivePathName() {
        return this.activename;
    }

    protected void updateActiveName() {
        String name = this.determineActivePathName();
        if (this.activename == null || !this.activename.equals(name)) {
            String old = this.activename;
            this.activename = name;
            this.firePropertyChange(PROP_ACTIVE_NAME, old, name);
        }
    }

    protected String determineActivePathName() {
        StringBuilder b = new StringBuilder();
        String sep = "";
        for (Object o : this.getActivePath().getPath()) {
            b.append(sep);
            sep = "/";
            b.append(((MandelListFolder)o).getName());
        }
        return b.toString();
    }

    private static void dump(String msg, TreePath p) {
        if (debug) {
            Object[] oa;
            System.out.println(msg + ":");
            for (Object o : oa = p.getPath()) {
                System.out.println("  " + o);
            }
            System.out.println("--");
        }
    }

    private static void dump(String msg, TreeModelEvent e) {
        if (debug) {
            Object[] oa;
            System.out.println(msg + ":");
            for (Object o : oa = e.getPath()) {
                System.out.println("  " + o);
            }
            oa = e.getChildren();
            if (oa != null && oa.length > 0) {
                System.out.println("  children:");
                for (Object o : oa) {
                    System.out.println("  " + o);
                }
            }
        }
    }

    public static TreePath getParentPath(TreeModelEvent e, TreePath path) {
        TreePath parent = null;
        MandelListFolderBrowserModel.dump("check parent", e);
        MandelListFolderBrowserModel.dump("for", path);
        if (e.getTreePath().isDescendant(path)) {
            Object[] children = e.getChildren();
            int length = e.getTreePath().getPathCount();
            if (children != null && children.length > 0) {
                if (length != path.getPathCount()) {
                    Object n = path.getPathComponent(length);
                    for (int i = 0; i < children.length; ++i) {
                        if (children[i] != n) continue;
                        parent = e.getTreePath().pathByAddingChild(n);
                        break;
                    }
                }
            } else {
                parent = e.getTreePath();
            }
        }
        return parent;
    }

    private void fireTreeNodesChanged(MandelListFolder f) {
        this.fireTreeNodesChanged(MandelListFolderTreeModelSupport.getPathToRoot(f), null, null);
    }

    private boolean contains(TreePath p, MandelListFolder f) {
        while (p != null) {
            if (p.getLastPathComponent() == f) {
                return true;
            }
            p = p.getParentPath();
        }
        return false;
    }

    private TreePath subPathTo(TreePath p, MandelListFolder f) {
        while (p != null) {
            if (p.getLastPathComponent() == f) {
                return p;
            }
            p = p.getParentPath();
        }
        return null;
    }

    private TreePath findFolder(TreePath root, MandelListFolder f) {
        Stack<MandelListFolder> path = new Stack<MandelListFolder>();
        MandelListFolder r = (MandelListFolder)root.getLastPathComponent();
        if (r == f) {
            return root;
        }
        for (MandelListFolder c : r) {
            if (!this.findFolder(path, c, f)) continue;
            for (MandelListFolder s : path) {
                root = root.pathByAddingChild(s);
            }
            return root;
        }
        return null;
    }

    private boolean findFolder(Stack<MandelListFolder> path, MandelListFolder r, MandelListFolder f) {
        path.push(r);
        if (r == f) {
            return true;
        }
        for (MandelListFolder c : r) {
            if (!this.findFolder(path, c, f)) continue;
            return true;
        }
        path.pop();
        return false;
    }

    @Override
    public void addMandelListFolderTreeModelListener(MandelListFolderTreeModelListener l) {
        this.listenerList.add(MandelListFolderTreeModelListener.class, l);
    }

    @Override
    public void removeMandelListFolderTreeModelListener(MandelListFolderTreeModelListener l) {
        this.listenerList.remove(MandelListFolderTreeModelListener.class, l);
    }

    @Override
    public MandelListFolderTreeModelListener[] getMandelListFolderTreeModelListeners() {
        return (MandelListFolderTreeModelListener[])this.getListeners(MandelListFolderTreeModelListener.class);
    }

    protected void fireFoldersDeleted(TreePath path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((MandelListFolderTreeModelListener)listeners[i + 1]).foldersDeleted(e);
        }
    }

    @Override
    public MandelListFolderTreeModel getEffectiveFolderTreeModel() {
        return this.getFolderTreeModel();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.fmodel.valueForPathChanged(path, newValue);
    }

    @Override
    public void save() {
        this.fmodel.save();
    }

    @Override
    public MandelListFolder getRoot() {
        return this.fmodel.getRoot();
    }

    @Override
    public MandelListTableModel getRootModel() {
        return this.fmodel.getRootModel();
    }

    @Override
    public MandelListTableModel getMandelListModel(Object folder) {
        return this.fmodel.getMandelListModel(folder);
    }

    @Override
    public boolean isPathTransferable(TreePath path) {
        return this.fmodel.isPathTransferable(path);
    }

    @Override
    public boolean isPathModifiable(TreePath path) {
        return this.fmodel.isPathModifiable(path);
    }

    @Override
    public boolean isPathListModifiable(TreePath path) {
        return this.fmodel.isPathListModifiable(path);
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        return this.fmodel.isPathEditable(path);
    }

    @Override
    public boolean isLocalFolder(MandelListFolder f) {
        return this.fmodel.isLocalFolder(f);
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.fmodel.isLeaf(node);
    }

    @Override
    public boolean insertFolders(int index, MandelListFolder[] folders, MandelListFolder parent) {
        return this.fmodel.insertFolders(index, folders, parent);
    }

    @Override
    public MandelListFolder insertFolder(String name, MandelListFolder parent) {
        return this.fmodel.insertFolder(name, parent);
    }

    @Override
    public void removeFolder(MandelListFolder node) {
        this.fmodel.removeFolder(node);
    }

    @Override
    public void moveFolders(int index, MandelListFolder[] folders, MandelListFolder parent) {
        this.fmodel.moveFolders(index, folders, parent);
    }

    @Override
    public void setThumbnailName(MandelListFolder folder, QualifiedMandelName name) {
        this.fmodel.setThumbnailName(folder, name);
    }

    @Override
    public boolean isMoving() {
        return this.fmodel.isMoving();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.fmodel.getIndexOfChild(parent, child);
    }

    @Override
    public MandelListFolderTree getFolderTree() {
        return this.fmodel.getFolderTree();
    }

    @Override
    public int getChildCount(Object parent) {
        return this.fmodel.getChildCount(parent);
    }

    @Override
    public MandelListFolder getChild(MandelListFolder parent, String name) {
        return this.fmodel.getChild(parent, name);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.fmodel.getChild(parent, index);
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.fmodel.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    @Override
    public void addAll(MandelListFolder f, QualifiedMandelName[] list) {
        this.fmodel.addAll(f, list);
    }

    @Override
    public void add(MandelListFolder f, QualifiedMandelName name) {
        this.fmodel.add(f, name);
    }

    @Override
    public void remove(MandelListFolder f, QualifiedMandelName name) {
        this.fmodel.remove(f, name);
    }

    @Override
    public boolean importData(DnDTreeModel.TransferSupport info) {
        return this.fmodel.importData(info);
    }

    @Override
    public int getSourceActions() {
        return this.fmodel.getSourceActions();
    }

    @Override
    public DropMode getDropMode() {
        return this.fmodel.getDropMode();
    }

    @Override
    public void exportDone(Transferable data, int action) {
        this.fmodel.exportDone(data, action);
    }

    @Override
    public Transferable createTransferable(DnDTreeModel.DragLocation loc) {
        return this.fmodel.createTransferable(loc);
    }

    @Override
    public boolean canImport(DnDTreeModel.TransferSupport info) {
        return this.fmodel.canImport(info);
    }

    private class ForwardingListener
    implements PropertyChangeListener,
    TreeModelListener,
    MandelListFolderTreeModelListener {
        private ForwardingListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MandelListFolderBrowserModel.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        public void foldersDeleted(TreeModelEvent e) {
            MandelListFolderBrowserModel.this.fireFoldersDeleted(e.getTreePath(), e.getChildIndices(), e.getChildren());
        }

        public void treeNodesChanged(TreeModelEvent e) {
            System.out.println("forward TNC ");
            MandelListFolderBrowserModel.this.fireTreeNodesChanged(e.getTreePath(), e.getChildIndices(), e.getChildren());
            Object[] children = e.getChildren();
            MandelListFolder f = (MandelListFolder)e.getTreePath().getLastPathComponent();
            if (MandelListFolderListModel.getParentPath(e, MandelListFolderBrowserModel.this.getActivePath()) != null) {
                MandelListFolderBrowserModel.this.updateActiveName();
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
            Object[] children = e.getChildren();
            TreePath a = null;
            MandelListFolderBrowserModel.this.fireTreeNodesInserted(e.getTreePath(), e.getChildIndices(), children);
            if (children == null || children.length == 0) {
                a = MandelListFolderBrowserModel.this.findFolder(e.getTreePath(), MandelListFolderBrowserModel.this.activefolder);
            } else {
                for (int i = 0; i < children.length && a == null; ++i) {
                    a = MandelListFolderBrowserModel.this.findFolder(e.getTreePath().pathByAddingChild(children[i]), MandelListFolderBrowserModel.this.activefolder);
                }
            }
            if (a != null) {
                MandelListFolderBrowserModel.this.setActivePath(a);
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            MandelListFolderBrowserModel.this.fireTreeNodesRemoved(e.getTreePath(), e.getChildIndices(), e.getChildren());
            if (!MandelListFolderBrowserModel.this.isMoving()) {
                this.handleReorg(e, true);
            }
        }

        public void treeStructureChanged(TreeModelEvent e) {
            MandelListFolderBrowserModel.this.fireTreeStructureChanged(e.getPath(), e.getChildIndices(), e.getChildren());
            this.handleReorg(e, false);
        }

        private void handleReorg(TreeModelEvent e, boolean remove) {
            TreePath parent = MandelListFolderBrowserModel.getParentPath(e, MandelListFolderBrowserModel.this.activepath);
            if (parent != null) {
                MandelListFolderBrowserModel.this.setActivePath(remove ? parent.getParentPath() : parent, true);
            }
        }
    }
}

