/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.swing.ChangeListenerSupport;
import com.mandelsoft.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeListener;

public class MandelVariantModel
extends AbstractListModel
implements ComboBoxModel {
    private ChangeListenerSupport listeners = new ChangeListenerSupport();
    protected MandelName name;
    protected MandelScanner scanner;
    protected List<MandelHandle> list;
    protected String selected;

    public MandelVariantModel(MandelScanner scanner) {
        this.scanner = scanner;
        this.name = MandelName.ROOT;
        this.list = new ArrayList<MandelHandle>();
    }

    public MandelName getName() {
        return this.name;
    }

    public void refresh(QualifiedMandelName name) {
        if (name == null) {
            return;
        }
        this.name = name.getMandelName();
        this.refresh(name.getQualifier());
    }

    private int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    protected String getLabel(String q) {
        if (Utils.isEmpty(q)) {
            return "<default>";
        }
        return q;
    }

    public void refresh(String sel) {
        int old = this.list.size();
        this.list.clear();
        sel = this.getLabel(sel);
        Set<MandelHandle> n = this.scanner.getMandelHandles(this.name);
        System.out.println("*** update variants: " + n);
        this.selected = null;
        if (n != null) {
            for (MandelHandle h : n) {
                String v = h.getQualifier();
                System.out.println("found " + v + ": " + h.getFile());
                if (this.getLabel(v).equals(sel)) {
                    this.selected = sel;
                }
                for (int i = 0; h != null && i < this.list.size(); ++i) {
                    if (this.compare(this.list.get(i).getQualifier(), v) < 0) continue;
                    this.list.add(i, h);
                    h = null;
                }
                if (h == null) continue;
                this.list.add(h);
            }
        }
        this.fireContentsChanged(this, 0, Math.max(old, this.list.size()) - 1);
    }

    public String getName(int index) {
        MandelHandle h = this.list.get(index);
        return h == null ? null : ((QualifiedMandelName)h.getName()).toString();
    }

    public Object getElementAt(int index) {
        if (index >= this.list.size()) {
            return "<none>";
        }
        MandelHandle h = this.list.get(index);
        if (h == null) {
            return "";
        }
        return this.getLabel(h.getQualifier());
    }

    public QualifiedMandelName getElement(Object item) {
        for (MandelHandle h : this.list) {
            if (!this.getLabel(h.getQualifier()).equals(item)) continue;
            return (QualifiedMandelName)h.getName();
        }
        return null;
    }

    public QualifiedMandelName getVariantName() {
        if (this.selected == null) {
            return null;
        }
        return this.getElement(this.selected);
    }

    public int getSize() {
        return this.list.size();
    }

    public Object getSelectedItem() {
        return this.selected;
    }

    public void setSelectedItem(Object anItem) {
        this.selected = (String)anItem;
        this.fireContentsChanged(this, 0, this.list.size() - 1);
        this.fireChangeEvent();
    }

    public void removeChangeListener(ChangeListener h) {
        this.listeners.removeChangeListener(h);
    }

    public void addChangeListener(ChangeListener h) {
        this.listeners.addChangeListener(h);
    }

    private void fireChangeEvent() {
        this.listeners.fireChangeEvent();
    }
}

