/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.util.ArrayColorList;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class FileColorList
extends ArrayColorList {
    private AbstractFile file;

    public FileColorList(File f) {
        this.setup(new FileAbstractFile(f));
    }

    public FileColorList(AbstractFile f) {
        this.setup(f);
    }

    protected void setup(AbstractFile f) {
        this.file = f;
        this.refresh(true);
    }

    public boolean valid() {
        if (this.file.isFile()) {
            return this.file.getFile().isFile();
        }
        return this.file.getLastModified() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean soft) {
        this.clear();
        if (this.valid()) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(this.file.getInputStream()));
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                        Color color = this.parseColor(line);
                        this.add(color);
                    }
                }
                finally {
                    r.close();
                }
            }
            catch (IOException ex) {
                System.out.println("ERROR in " + this.file + ": " + ex);
            }
        }
    }

    protected Color parseColor(String line) throws IOException {
        StringTokenizer t = new StringTokenizer(line, ",");
        try {
            if (t.hasMoreTokens()) {
                String s = t.nextToken();
                int r = Integer.parseInt(s.trim());
                if (t.hasMoreTokens()) {
                    s = t.nextToken();
                    int g = Integer.parseInt(s.trim());
                    if (t.hasMoreTokens()) {
                        s = t.nextToken();
                        int b = Integer.parseInt(s.trim());
                        if (!t.hasMoreTokens()) {
                            return new Color(r, g, b);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException("cannot parse line: " + line + ": " + e, e);
        }
        throw new IOException("cannot parse line: " + line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (!this.file.isFile()) {
            throw new UnsupportedOperationException("save on URL");
        }
        PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter(this.file.getFile())));
        try {
            for (Color c : this) {
                w.println(c.getRed() + ", " + c.getGreen() + ", " + c.getBlue());
            }
        }
        finally {
            w.close();
        }
    }

    public static void main(String[] args) {
        FileColorList list = new FileColorList(new File("C:/work/AccuRev/test/Mandel/colors"));
        for (Color c : list) {
            System.out.println("  " + c);
        }
        try {
            list.add(Color.ORANGE);
            list.save();
        }
        catch (IOException io) {
            System.out.println("cannot save list: " + io);
        }
    }
}

