/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public interface MandelListFolderTree {
    public MandelListFolder getRoot();

    public boolean valid();

    public void refresh();

    public void save() throws IOException;

    public void save(File var1) throws IOException;

    public void read(InputStream var1, String var2) throws IOException;

    public void write(OutputStream var1, String var2) throws IOException;

    public static class IO {
        public static final Modifier std = new ModifierAdapter();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void read(MandelListFolderTree tree, InputStream is, String src) throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                IO.readContent(tree.getRoot(), br);
            }
            finally {
                br.close();
            }
        }

        public static void write(MandelListFolderTree tree, OutputStream os, String dst) throws IOException {
            IO.write(tree, std, os, dst);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void write(MandelListFolderTree tree, Modifier m, OutputStream os, String dst) throws IOException {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
            if (m == null) {
                m = std;
            }
            try {
                pw.println("#$ StandardTreeFormat");
                m.writeHeader(pw);
                IO.writeContent("", m, tree.getRoot(), pw);
            }
            finally {
                pw.close();
            }
        }

        private static void writeContent(String gap, Modifier m, MandelListFolder f, PrintWriter w) {
            String ngap = gap + "  ";
            for (String string : m.propertyNames(f)) {
                w.println(gap + string + "=" + m.getProperty(f, string));
            }
            if (f.hasMandelList()) {
                for (QualifiedMandelName qualifiedMandelName : m.getMandelList(f)) {
                    w.println(gap + qualifiedMandelName);
                }
            }
            for (MandelListFolder mandelListFolder : m.folders(f)) {
                String t = "";
                if (m.getThumbnailName(mandelListFolder) != null) {
                    t = " [" + mandelListFolder.getThumbnailName() + "]";
                }
                w.println(gap + mandelListFolder.getName() + t + " {");
                IO.writeContent(ngap, m, mandelListFolder, w);
                w.println(gap + "}");
            }
        }

        private static boolean readContent(MandelListFolder folder, BufferedReader r) throws IOException {
            String line;
            MandelList list = folder.getMandelList();
            while ((line = r.readLine()) != null) {
                Object name;
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                int ix = line.indexOf(61);
                if (line.endsWith("{")) {
                    String n = line.substring(0, line.length() - 1).trim();
                    String t = null;
                    if (n.endsWith("]")) {
                        ix = n.indexOf("[");
                        if (ix > 0) {
                            t = n.substring(ix + 1, n.length() - 1).trim();
                            n = n.substring(0, ix).trim();
                        } else {
                            throw new IOException("illegal sub folder name syntax");
                        }
                    }
                    MandelListFolder f = folder.createSubFolder(n);
                    if (t != null) {
                        f.setThumbnailName(QualifiedMandelName.create(t));
                    }
                    if (IO.readContent(f, r)) continue;
                    throw new IOException("illegal sub folder syntax");
                }
                if (line.equals("}")) {
                    return true;
                }
                if (ix > 0) {
                    name = line.substring(0, ix).trim();
                    String value = line.substring(ix + 1).trim();
                    folder.setProperty((String)name, value);
                    continue;
                }
                name = QualifiedMandelName.create(line);
                list.add(name);
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ModifierAdapter
        implements Modifier {
            @Override
            public void writeHeader(PrintWriter pw) {
            }

            @Override
            public QualifiedMandelName getThumbnailName(MandelListFolder f) {
                return f.getThumbnailName();
            }

            @Override
            public Iterable<String> propertyNames(MandelListFolder f) {
                return f.propertyNames();
            }

            @Override
            public String getProperty(MandelListFolder f, String name) {
                return f.getProperty(name);
            }

            @Override
            public MandelList getMandelList(MandelListFolder f) {
                return f.getMandelList();
            }

            @Override
            public Iterable<MandelListFolder> folders(MandelListFolder f) {
                return f;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Modifier {
            public void writeHeader(PrintWriter var1);

            public QualifiedMandelName getThumbnailName(MandelListFolder var1);

            public Iterable<String> propertyNames(MandelListFolder var1);

            public String getProperty(MandelListFolder var1, String var2);

            public MandelList getMandelList(MandelListFolder var1);

            public Iterable<MandelListFolder> folders(MandelListFolder var1);
        }
    }
}

