/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.ArrayMandelListFolder;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.mand.util.UniqueArrayMandelList;
import java.io.BufferedReader;
import java.io.IOException;

public class NestedMandelListFolder
extends ArrayMandelListFolder {
    private MandelListFolderTree tree;

    public NestedMandelListFolder(MandelListFolderTree tree, String name) {
        super(name);
        this.tree = tree;
    }

    protected MandelList createMandelList() {
        return new FolderMandelList();
    }

    public MandelListFolderTree getMandelListFolderTree() {
        return this.tree;
    }

    public void refresh(boolean soft) {
        this.getMandelListFolderTree().refresh();
    }

    public void save() throws IOException {
        this.getMandelListFolderTree().save();
    }

    public boolean valid() {
        if (this.getParent() != null) {
            return this.getParent().valid();
        }
        return super.valid();
    }

    protected boolean readContent(BufferedReader r) throws IOException {
        String line;
        MandelList list = this.getMandelList();
        while ((line = r.readLine()) != null) {
            Object name;
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            int ix = line.indexOf(61);
            if (line.endsWith("{")) {
                String n = line.substring(0, line.length() - 1).trim();
                String t = null;
                if (n.endsWith("]")) {
                    ix = n.indexOf("[");
                    if (ix > 0) {
                        t = n.substring(ix + 1, n.length() - 1).trim();
                        n = n.substring(0, ix).trim();
                    } else {
                        throw new IOException("illegal sub folder name syntax");
                    }
                }
                NestedMandelListFolder f = this.createSubFolder(n);
                if (t != null) {
                    f.setThumbnailName(QualifiedMandelName.create(t));
                }
                if (f.readContent(r)) continue;
                throw new IOException("illegal sub folder syntax");
            }
            if (line.equals("}")) {
                return true;
            }
            if (ix > 0) {
                name = line.substring(0, ix).trim();
                String value = line.substring(ix + 1).trim();
                this.setProperty((String)name, value);
                continue;
            }
            if (this.hasMandelList()) {
                name = QualifiedMandelName.create(line);
                list.add(name);
                continue;
            }
            throw new IOException("list entry in plain folder without list");
        }
        return false;
    }

    public NestedMandelListFolder createSubFolder(String name) {
        NestedMandelListFolder f = this.createNestedFolder(name);
        super.add(f);
        return f;
    }

    public NestedMandelListFolder createSubFolder(int index, String name) {
        NestedMandelListFolder f = this.createNestedFolder(name);
        if (index < 0) {
            index = this.size();
        }
        super.add(index, f);
        return f;
    }

    protected NestedMandelListFolder createNestedFolder(String name) {
        return new NestedMandelListFolder(this.getMandelListFolderTree(), name);
    }

    public boolean add(MandelListFolder f) {
        if (!(f instanceof NestedMandelListFolder)) {
            throw new IllegalArgumentException("illegal folder type " + f.getClass());
        }
        return super.add(f);
    }

    public void add(int index, MandelListFolder f) {
        if (!(f instanceof NestedMandelListFolder)) {
            throw new IllegalArgumentException("illegal folder type " + f.getClass());
        }
        super.add(index, f);
    }

    private class FolderMandelList
    extends UniqueArrayMandelList {
        private FolderMandelList() {
        }

        public void refresh(boolean soft) {
            NestedMandelListFolder.this.refresh(soft);
        }

        public void save() throws IOException {
            NestedMandelListFolder.this.save();
        }

        public boolean valid() {
            return NestedMandelListFolder.this.valid();
        }
    }
}

