/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.Interval2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class Dimensions {
    public static String toString(Dimension2D lo) {
        return "[" + lo.getWidth() + "," + lo.getHeight() + "]";
    }

    public static boolean empty(Dimension2D d) {
        return d.getWidth() == 0.0 && d.getHeight() == 0.0;
    }

    public static boolean isNegative(Dimension2D d) {
        return d.getHeight() < 0.0 || d.getWidth() < 0.0;
    }

    public static class op {
        public static Dimension2D add(Dimension2D a, Dimension2D b) {
            return new Dimension(a.getWidth() + b.getWidth(), a.getHeight() + b.getHeight());
        }

        public static Dimension2D sub(Dimension2D a, Dimension2D b) {
            return new Dimension(a.getWidth() - b.getWidth(), a.getHeight() - b.getHeight());
        }

        public static Dimension2D neg(Dimension2D d) {
            return new Dimension(-d.getWidth(), -d.getHeight());
        }
    }

    public static class mod {
        public static void add(Dimension2D d, Dimension2D d2) {
            d.setSize(d.getWidth() + d2.getWidth(), d.getHeight() + d2.getHeight());
        }

        public static void add(Dimension2D d, double w, double h) {
            d.setSize(d.getWidth() + w, d.getHeight() + h);
        }

        public static void addX(Dimension2D d, Interval2D w) {
            d.setSize(d.getWidth() + w.size(), d.getHeight());
        }

        public static void addX(Dimension2D d, double w) {
            d.setSize(d.getWidth() + w, d.getHeight());
        }

        public static void addY(Dimension2D d, Interval2D h) {
            d.setSize(d.getWidth(), d.getHeight() + h.size());
        }

        public static void addY(Dimension2D d, double h) {
            d.setSize(d.getWidth(), d.getHeight() + h);
        }

        public static void neg(Dimension2D d) {
            d.setSize(-d.getWidth(), -d.getHeight());
        }

        public static void sub(Dimension2D d, Dimension2D d2) {
            d.setSize(d.getWidth() - d2.getWidth(), d.getHeight() - d2.getHeight());
        }

        public static void sub(Dimension2D d, double w, double h) {
            d.setSize(d.getWidth() - w, d.getHeight() - h);
        }

        public static void subX(Dimension2D d, Interval2D w) {
            d.setSize(d.getWidth() - w.size(), d.getHeight());
        }

        public static void subX(Dimension2D d, double w) {
            d.setSize(d.getWidth() - w, d.getHeight());
        }

        public static void subY(Dimension2D d, Interval2D h) {
            d.setSize(d.getWidth(), d.getHeight() - h.size());
        }

        public static void subY(Dimension2D d, double h) {
            d.setSize(d.getWidth(), d.getHeight() - h);
        }

        public static void extend(Dimension2D d1, Dimension2D d2) {
            if (d2.getWidth() > d1.getWidth()) {
                d1.setSize(d2.getWidth(), d1.getHeight());
            }
            if (d2.getHeight() > d1.getHeight()) {
                d1.setSize(d1.getWidth(), d2.getHeight());
            }
        }

        public static void limit(Dimension2D d, Dimension2D d2) {
            mod.limit(d, d2.getWidth(), d2.getHeight());
        }

        public static void limit(Dimension2D d, double w, double h) {
            if (d.getWidth() < w) {
                w = d.getWidth();
            }
            if (d.getHeight() < h) {
                h = d.getHeight();
            }
            d.setSize(w, h);
        }

        public static void limitMin(Dimension2D d, double w, double h) {
            if (d.getWidth() > w) {
                w = d.getWidth();
            }
            if (d.getHeight() > h) {
                h = d.getHeight();
            }
            d.setSize(w, h);
        }

        public static void translate(Point2D p, Dimension2D d) {
            p.setLocation(p.getX() + d.getWidth(), p.getY() + d.getHeight());
        }
    }

    public static class Dimension
    extends Dimension2D {
        private double width;
        private double height;

        public Dimension() {
        }

        public Dimension(Dimension2D h) {
            this(h.getWidth(), h.getHeight());
        }

        public Dimension(double width, double height) {
            this.width = width;
            this.height = height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public void setSize(double width, double height) {
            this.width = width;
            this.height = height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public void setWidth(double width) {
            this.width = width;
        }
    }
}

