/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.DnDTableModel;
import com.mandelsoft.swing.IJTable;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DnDJTable
extends IJTable {
    public static boolean debug = false;
    private TableTransferHandler transfer;
    private ContextMenuHandler ctxmenu;
    private Listener listener;

    public DnDJTable() {
        super(new DefaultModel());
        this.setup();
    }

    public DnDJTable(DnDTableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.setup();
    }

    public DnDJTable(DnDTableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.setup();
    }

    public DnDJTable(DnDTableModel dm) {
        super(dm);
        this.setup();
    }

    private void setup() {
        this.transfer = this.createTableTransferHandler();
        this.setTransferHandler(this.transfer);
        this.setDropMode();
    }

    public DnDTableModel getModel() {
        return (DnDTableModel)super.getModel();
    }

    public void setModel(TableModel dataModel) {
        this.setModel((DnDTableModel)dataModel);
    }

    public void setModel(DnDTableModel dataModel) {
        super.setModel(dataModel);
        this.setDropMode();
    }

    private void setDropMode() {
        DropMode mode = null;
        if (this.getModel() != null) {
            mode = this.getModel().getDropMode();
        }
        if (mode != null) {
            this.setDragEnabled(true);
            this.setDropMode(mode);
        } else {
            this.setDragEnabled(false);
        }
    }

    protected TableTransferHandler createTableTransferHandler() {
        return new TableTransferHandler();
    }

    public synchronized void setContextMenuHandler(ContextMenuHandler h) {
        if (h == null) {
            if (this.ctxmenu != null) {
                this.removeMouseListener(this.listener);
            }
        } else if (this.ctxmenu == null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            this.addMouseListener(this.listener);
        }
        this.ctxmenu = h;
    }

    public static interface ContextMenuHandler {
        public void handleContextMenu(JComponent var1, MouseEvent var2, int var3, int var4);
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        public void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger() && DnDJTable.this.ctxmenu != null) {
                int row = DnDJTable.this.rowAtPoint(e.getPoint());
                int modelRow = DnDJTable.this.convertRowIndexToModel(row);
                int col = DnDJTable.this.columnAtPoint(e.getPoint());
                int modelCol = DnDJTable.this.convertColumnIndexToModel(col);
                if (debug) {
                    System.out.println("CTX POPUP at " + modelRow + "," + modelCol);
                }
                DnDJTable.this.ctxmenu.handleContextMenu(DnDJTable.this, e, modelRow, modelCol);
            }
        }
    }

    protected class TableTransferHandler
    extends TransferHandler {
        private Transferable trans = null;

        protected TableTransferHandler() {
        }

        public boolean canImport(TransferHandler.TransferSupport info) {
            return ((DnDJTable)info.getComponent()).getModel().canImport(new DnDTableModel.TransferSupport(info));
        }

        protected Transferable createTransferable(JComponent c) {
            this.trans = ((DnDJTable)c).getModel().createTransferable(new DnDTableModel.DragLocation((DnDJTable)c));
            return this.trans;
        }

        public int getSourceActions(JComponent c) {
            return ((DnDJTable)c).getModel().getSourceActions();
        }

        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            return ((DnDJTable)info.getComponent()).getModel().importData(new DnDTableModel.TransferSupport(info));
        }

        protected void exportDone(JComponent c, Transferable data, int action) {
            if (this.trans != null) {
                ((DnDJTable)c).getModel().exportDone(this.trans, action);
            }
            this.trans = null;
        }
    }

    public static class DefaultModel
    extends DefaultTableModel
    implements DnDTableModel {
        public DropMode getDropMode() {
            return null;
        }

        public int getSourceActions() {
            return 0;
        }

        public Transferable createTransferable(DnDTableModel.DragLocation loc) {
            return null;
        }

        public void exportDone(Transferable data, int action) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean canImport(DnDTableModel.TransferSupport info) {
            return false;
        }

        public boolean importData(DnDTableModel.TransferSupport info) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

