/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.IJTree;
import com.mandelsoft.swing.ITreeModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.DropMode;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public interface DnDTreeModel
extends ITreeModel {
    public DropMode getDropMode();

    public int getSourceActions();

    public Transferable createTransferable(DragLocation var1);

    public void exportDone(Transferable var1, int var2);

    public boolean canImport(TransferSupport var1);

    public boolean importData(TransferSupport var1);

    public static class DragLocation {
        private IJTree tree;

        public DragLocation(IJTree t) {
            this.tree = t;
        }

        public IJTree getComponent() {
            return this.tree;
        }

        public TreePath[] getSelectionPaths() {
            return this.tree.getSelectionPaths();
        }

        public TreePath getSelectionPath() {
            return this.tree.getSelectionPath();
        }

        public int getSelectionCount() {
            return this.tree.getSelectionCount();
        }

        public TreePath getLeadSelectionPath() {
            return this.tree.getLeadSelectionPath();
        }

        public Object getLastSelectedPathComponent() {
            return this.tree.getLastSelectedPathComponent();
        }
    }

    public static class TransferSupport {
        TransferHandler.TransferSupport orig;
        DropLocation location;

        TransferSupport(TransferHandler.TransferSupport orig) {
            this.orig = orig;
            this.location = new DropLocation(orig);
        }

        public void setShowDropLocation(boolean showDropLocation) {
            this.orig.setShowDropLocation(showDropLocation);
        }

        public void setDropAction(int dropAction) {
            this.orig.setDropAction(dropAction);
        }

        public boolean isDrop() {
            return this.orig.isDrop();
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            return this.orig.isDataFlavorSupported(df);
        }

        public int getUserDropAction() {
            return this.orig.getUserDropAction();
        }

        public Transferable getTransferable() {
            return this.orig.getTransferable();
        }

        public int getSourceDropActions() {
            return this.orig.getSourceDropActions();
        }

        public DropLocation getDropLocation() {
            return this.location;
        }

        public int getDropAction() {
            return this.orig.getDropAction();
        }

        public DataFlavor[] getDataFlavors() {
            return this.orig.getDataFlavors();
        }

        public IJTree getComponent() {
            return this.location.getComponent();
        }
    }

    public static class DropLocation
    extends TransferHandler.DropLocation {
        private JTree.DropLocation location;
        private IJTree tree;

        public DropLocation(TransferHandler.TransferSupport trans) {
            super(trans.getDropLocation().getDropPoint());
            this.location = (JTree.DropLocation)trans.getDropLocation();
            this.tree = (IJTree)trans.getComponent();
        }

        public int getChildIndex() {
            return this.location.getChildIndex();
        }

        public TreePath getPath() {
            return this.location.getPath();
        }

        public IJTree getComponent() {
            return this.tree;
        }

        public String toString() {
            return this.location.toString();
        }
    }
}

