/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.DataField;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.TextAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextField
extends JTextField
implements DataField<String> {
    private String old;
    private Action[] defaultActions;

    public TextField(String txt) {
        super(txt);
        this.old = txt;
    }

    public TextField() {
        super("");
    }

    @Override
    public Action[] getActions() {
        if (this.defaultActions == null) {
            this.defaultActions = new Action[]{new CommitAction()};
        }
        return TextAction.augmentList(super.getActions(), this.defaultActions);
    }

    @Override
    public String getDataValue() {
        return this.getText();
    }

    @Override
    public void setDataValue(String v) {
        this.setText(v);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.isTemporary()) {
            return;
        }
        if (e.getID() == 1005) {
            this._setText(this.getText());
        }
    }

    @Override
    public void setText(String v) {
        super.setText(v);
        this._setText(v);
    }

    protected void _setText(String v) {
        if (v != null && this.old != null && this.old.equals(v)) {
            return;
        }
        if (v == this.old) {
            return;
        }
        this.firePropertyChange("value", this.old, v);
        this.old = v;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestFrame frame = new TestFrame();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    static class TestFrame
    extends JFrame {
        TestFrame() {
            PropertyChangeListener listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    Object v = evt.getNewValue();
                    if (v != null) {
                        System.out.println("=" + evt.getPropertyName() + "=" + v);
                    }
                }
            };
            JTextField tf0 = new JTextField("test");
            tf0.setColumns(10);
            tf0.setHorizontalAlignment(11);
            tf0.addPropertyChangeListener(listener);
            TextField nf1 = new TextField();
            nf1.setColumns(20);
            nf1.setDataValue("Test");
            nf1.setHorizontalAlignment(11);
            nf1.addPropertyChangeListener(listener);
            JButton b = new JButton();
            b.setContentAreaFilled(true);
            b.setBackground(Color.BLUE);
            this.setLayout(new FlowLayout());
            this.add(tf0);
            this.add(nf1);
            this.add(b);
            this.pack();
        }
    }

    private class CommitAction
    extends AbstractAction {
        public CommitAction() {
            super("notify-field-accept");
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                TextField.this._setText(TextField.this.getText());
            }
        }

        public boolean isEnabled() {
            return TextField.this.isEditable();
        }
    }
}

