/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing.colorchooser;

import com.mandelsoft.swing.colorchooser.SyntheticImage;
import java.awt.image.ImageConsumer;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SyntheticImageGenerator
extends Thread {
    ImageConsumer ic;
    boolean useful;
    SyntheticImageGenerator next;
    SyntheticImage parent;

    SyntheticImageGenerator(ImageConsumer ic, SyntheticImageGenerator next, SyntheticImage parent) {
        super("SyntheticImageGenerator");
        this.ic = ic;
        this.next = next;
        this.parent = parent;
        this.useful = true;
        this.setDaemon(true);
    }

    public void run() {
        ImageConsumer ic = this.ic;
        int w = this.parent.width;
        int h = this.parent.height;
        int hints = 8 | 4 | 2;
        if (this.parent.isStatic()) {
            hints |= 0x10;
        }
        ic.setHints(hints);
        ic.setDimensions(w, h);
        ic.setProperties(null);
        ic.setColorModel(SyntheticImage.cm);
        if (this.useful) {
            int[] row = new int[w];
            SyntheticImageGenerator.doPrivileged(new Runnable(){

                public void run() {
                    Thread.currentThread().setPriority(1);
                }
            });
            do {
                for (int y = 0; y < h && this.useful; ++y) {
                    this.parent.computeRow(y, row);
                    if (this.parent.aborted) {
                        ic.imageComplete(4);
                        return;
                    }
                    ic.setPixels(0, y, w, 1, SyntheticImage.cm, row, 0, w);
                }
                ic.imageComplete(this.parent.isStatic() ? 3 : 2);
            } while (!this.parent.isStatic() && this.useful);
        }
    }

    private static final void doPrivileged(final Runnable doRun) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                doRun.run();
                return null;
            }
        });
    }
}

